<?php 
/**
 * The template for displaying features content within single
 *
 * This template can be overridden by copying it to yourtheme/ovabrw-templates/single/features.php
 *
 */

if ( ! defined( 'ABSPATH' ) ) exit();

// Get product_id from do_action - use when insert shortcode
if( isset( $args['id'] ) && $args['id'] ){
	$pid = $args['id'];
}else{
	$pid = get_the_id();
}

// Check product type: rental
$product = wc_get_product( $pid );

if ( !$product || $product->get_type() !== 'ovabrw_car_rental' ) return;

$number_column 	= isset( $args['number_column'] ) ? $args['number_column'] : 'three_column';

$ovabrw_features_icons  = get_post_meta( $pid, 'ovabrw_features_icons', true );
$ovabrw_features_label  = get_post_meta( $pid, 'ovabrw_features_label', true );



if( !empty( $ovabrw_features_icons && $ovabrw_features_label )){ ?>
<ul class="ovabrw_woo_features <?php echo esc_attr($number_column); ?>">
	<?php foreach ($ovabrw_features_icons as $key => $value) { ?>

		<li>
			<?php if( !empty( $ovabrw_features_icons[$key] ) ){ ?>
				<i class="<?php echo esc_html( $value ); ?>"></i>
			<?php } ?>
			<?php if( isset( $ovabrw_features_label[$key] ) && !empty( $ovabrw_features_label[$key] ) ){ ?>
				<label><?php echo esc_html( $ovabrw_features_label[$key] ); ?></label>
			<?php } ?>
		</li>

	<?php } ?>
</ul>
<?php } ?>
