<?php
if ( !defined( 'ABSPATH' ) ) exit();

add_action( 'wp_ajax_ovabrw_load_name_product', 'ovabrw_load_name_product' );
add_action( 'wp_ajax_nopriv_ovabrw_load_name_product', 'ovabrw_load_name_product' );
function ovabrw_load_name_product() {
	$keyword = isset($_POST['keyword']) ? sanitize_text_field( $_POST['keyword'] ) : '';

	$the_query = new WP_Query( array( 'post_type' => 'product' , 's' => $keyword, 'posts_per_page'=> '10') );
	?>

	<?php

	if( $the_query->have_posts() ) :
		while( $the_query->have_posts() ): $the_query->the_post();

			$title[] = get_the_title();

		endwhile;
		wp_reset_postdata();  
	endif;

	echo json_encode($title);

	wp_die();
}


add_action( 'wp_ajax_ovabrw_load_name_product_id', 'ovabrw_load_name_product_id' );
add_action( 'wp_ajax_nopriv_ovabrw_load_name_product_id', 'ovabrw_load_name_product_id' );
function ovabrw_load_name_product_id() {
	$keyword = isset($_POST['keyword']) ? sanitize_text_field( $_POST['keyword'] ) : '';

	$the_query = new WP_Query( array( 'post_type' => 'product' , 's' => $keyword, 'posts_per_page'=> '10') );
	?>

	<?php

	if( $the_query->have_posts() ) :
		while( $the_query->have_posts() ): $the_query->the_post();

			$title[] = get_the_title() . '(#'.get_the_id().')';

		endwhile;
		wp_reset_postdata();  
	endif;

	echo json_encode($title);

	wp_die();
}

add_action( 'wp_ajax_ovabrw_get_rental_type_product', 'ovabrw_get_rental_type_product' );
add_action( 'wp_ajax_nopriv_ovabrw_get_rental_type_product', 'ovabrw_get_rental_type_product' );
function ovabrw_get_rental_type_product() {

	$id_product = isset($_POST['id_product']) ? sanitize_text_field( $_POST['id_product'] ) : '';
	$rental_type = get_post_meta( $id_product, 'ovabrw_price_type', true );

	$data = [
		'rental_type' => $rental_type,
	];
	echo json_encode( $data );

	wp_die();
}


add_action( 'wp_ajax_ovabrw_get_id_vehicle_rest', 'ovabrw_get_id_vehicle_rest' );
add_action( 'wp_ajax_nopriv_ovabrw_get_id_vehicle_rest', 'ovabrw_get_id_vehicle_rest' );
function ovabrw_get_id_vehicle_rest() {

	$id_product 	= isset($_POST['id_product']) ? sanitize_text_field( $_POST['id_product'] ) : '';
	$pickup_date 	= isset($_POST['pickup_date']) ? strtotime(sanitize_text_field( $_POST['pickup_date'] )) : '';
	$dropp_off 		= isset($_POST['dropp_off']) ? strtotime(sanitize_text_field( $_POST['dropp_off'] )) : '';
	$pickup_loc 	= isset($_POST['pickup_loc']) ? sanitize_text_field( $_POST['pickup_loc'] ) : '';
	$dropoff_loc 	= isset($_POST['dropoff_loc']) ? sanitize_text_field( $_POST['dropoff_loc'] ) : '';
	$package_id 	= isset($_POST['package_id']) ? sanitize_text_field( $_POST['package_id'] ) : '';

	$new_input_date = ovabrw_new_input_date( $id_product, $pickup_date, $dropp_off, $package_id, $pickup_loc, $dropoff_loc );

	$pickup_date_new 	= $new_input_date['pickup_date_new'];
	$pickoff_date_new 	= $new_input_date['pickoff_date_new'];

	$data_vehicle 		= ova_validate_manage_store( $id_product, $pickup_date_new, $pickoff_date_new, $pickup_loc, $dropoff_loc, true, 'search' );
	if ( $data_vehicle ) {
		$data = $data_vehicle;
	} else {
		$data = [
			'error' => true,
			'start_date' => 'empty',
			'message' => esc_html__("Vehicle is not available for this time, Please book other time.", 'ova-brw'),
		];
	}
	
	echo json_encode( $data );

	wp_die();
}


add_action( 'wp_ajax_ovabrw_load_data_product_create_order', 'ovabrw_load_data_product_create_order' );
add_action( 'wp_ajax_nopriv_ovabrw_load_data_product_create_order', 'ovabrw_load_data_product_create_order' );
function ovabrw_load_data_product_create_order() {
	$name_product 	= isset($_POST['name_product']) ? sanitize_text_field( $_POST['name_product'] ) : '';
	$id_product 	= trim( sanitize_text_field( $name_product ) );

	$rental_type 	= get_post_meta( $id_product, 'ovabrw_price_type', true );
	$petime_id 		= get_post_meta( $id_product, 'ovabrw_petime_id', true );
	$petime_label 	= get_post_meta( $id_product, 'ovabrw_petime_label', true );
	$product_price 	= get_post_meta( $id_product, '_regular_price', true);
    $max_adults     = get_post_meta( $id_product, 'ovabrw_adult_number', true );
    $max_childrens  = get_post_meta( $id_product, 'ovabrw_children_number', true );
    $max_yachts 		= get_post_meta( $id_product, 'ovabrw_car_count', true );
	$ovabrw_amount_insurance 	= get_post_meta( $id_product, 'ovabrw_amount_insurance', true );
	$ovabrw_id_vehicles 		= get_post_meta( $id_product, 'ovabrw_id_vehicles', true );
	$ovabrw_define_1_day 		= get_post_meta( $id_product, 'ovabrw_define_1_day', true);

	$unfixed_time 	= get_post_meta( $id_product, 'ovabrw_unfixed_time', true);

	if ( $rental_type == 'transportation' ) {
		// Get html pick-up location
		$html_pickup_location 	= ovabrw_get_locations_transport_html( 'ovabrw_pickoff_loc', 'required', '', $id_product, 'pickup' );
		// Get html drop-off location
		$html_dropoff_location 	= ovabrw_get_locations_transport_html( 'ovabrw_pickoff_loc', 'required', '', $id_product, 'dropoff' );
	} else {
		// Get html pick-up location
		$html_pickup_location 	= ovabrw_get_locations_html( 'ovabrw_pickoff_loc', 'required', '', $id_product, 'pickup' );
		// Get html drop-off location
		$html_dropoff_location 	= ovabrw_get_locations_html( 'ovabrw_pickoff_loc', 'required', '', $id_product, 'dropoff' );
	}

	// Show/hide Pick-up date
	$show_pickup_date 		= ovabrw_show_pick_date_product( $id_product, $type = 'pickup' );

	// Show/hide Drop-off date
	$show_pickoff_date 		= ovabrw_show_pick_date_product( $id_product, $type = 'dropoff' );

	// Get show number vehicle
	$show_number_vehicle 	= get_post_meta( $id_product, 'ovabrw_show_number_vehicle', true);

	// Get show pick-up, drop-off date location
	$show_pickup_loc 	= ovabrw_show_pick_location_product( $id_product, $type = 'pickup' );
	$show_pickoff_loc 	= ovabrw_show_pick_location_product( $id_product, $type = 'dropoff' );

	// Get html resources
	$html_resources 	= ovabrw_get_html_resources_order( $id_product );

	// Get html resources
	$html_services	 	= ovabrw_get_html_services_order( $id_product );

	$statuses 	= brw_list_order_status();
    $order_date = get_order_rent_time( $id_product, $statuses );

	$data = [
		'rental_type' 				=> $rental_type,
		'petime_id' 				=> $petime_id,
		'petime_label' 				=> $petime_label,
		'ovabrw_amount_insurance' 	=> $ovabrw_amount_insurance,
		'ovabrw_id_vehicles' 		=> $ovabrw_id_vehicles,
		'product_price' 			=> $product_price,
		'ovabrw_define_1_day' 		=> $ovabrw_define_1_day,
		'order_date' 				=> $order_date,
		'show_number_vehicle' 		=> $show_number_vehicle,
		'max_adults' 				=> $max_adults,
		'max_childrens' 			=> $max_childrens,
		'max_yachts' 				=> $max_yachts,
		'show_pickup_loc' 	  		=> $show_pickup_loc ? "yes" : "no",
		'show_pickoff_loc' 	  		=> $show_pickoff_loc ? "yes" : "no",
		'show_pickup_date'			=> $show_pickup_date ? 'yes' : 'no',
		'show_pickoff_date'			=> $show_pickoff_date ? 'yes' : 'no',
		'html_pickup_location'		=> $html_pickup_location,
		'html_dropoff_location' 	=> $html_dropoff_location,
		'html_resources' 			=> $html_resources,
		'html_services' 			=> $html_services,
		'unfixed_time'				=> $unfixed_time
	];

	echo json_encode( $data );

	wp_die();
}



add_action( 'wp_ajax_ovabrw_load_tag_product', 'ovabrw_load_tag_product' );
add_action( 'wp_ajax_nopriv_ovabrw_load_tag_product', 'ovabrw_load_tag_product' );
function ovabrw_load_tag_product() {
	$keyword = isset($_POST['keyword']) ? sanitize_text_field( $_POST['keyword'] ) : '';
	$args = array(
        'taxonomy'               => 'product_tag',
        'search' => $keyword
    );
    $the_query = new WP_Term_Query($args);

    $title = [];
    if ( $the_query->terms ) {
        foreach( $the_query->terms as $term ) {
            $title[] =  $term->name;
        }
        wp_reset_postdata();  
    }

	echo json_encode($title);

	wp_die();
}

add_action( 'wp_ajax_ovabrw_get_total_price_and_quantity', 'ovabrw_get_total_price_and_quantity' );
add_action( 'wp_ajax_nopriv_ovabrw_get_total_price_and_quantity', 'ovabrw_get_total_price_and_quantity' );
function ovabrw_get_total_price_and_quantity() {

	$id_product 	= isset($_POST['id_product']) ? trim( sanitize_text_field( $_POST['id_product'] ) ) : '';

	// Get rental type product
	$rental_type 	= get_post_meta( $id_product, 'ovabrw_price_type', true );

	// Check is Auto/Manual to make ID vehicle 
    $manage_store 	= get_post_meta( $id_product, 'ovabrw_manage_store', true );

	$start_date 	= isset($_POST['start_date']) ? trim( sanitize_text_field( $_POST['start_date'] ) ) : '';
	$end_date 		= isset($_POST['end_date']) ? trim( sanitize_text_field( $_POST['end_date'] ) ) : '';
	$id_package 	= isset($_POST['id_package']) ? trim( sanitize_text_field( $_POST['id_package'] ) ) : '';
	$number_vehicle = isset($_POST['number_vehicle']) ? trim( sanitize_text_field( $_POST['number_vehicle'] ) ) : 1;
	$pickup_loc 	= isset($_POST['pickup_loc']) ? trim( sanitize_text_field( $_POST['pickup_loc'] ) ) : '';
	$dropoff_loc 	= isset($_POST['dropoff_loc']) ? trim( sanitize_text_field( $_POST['dropoff_loc'] ) ) : '';

	$resources 		= isset($_POST['resources']) ? str_replace( '\\', '', $_POST['resources'] )  : '';
	$resources_data = (array) json_decode( $resources );

	$services 		= isset($_POST['services']) ? str_replace( '\\', '', $_POST['services'] )  : '';
	$services_data 	= (array) json_decode( $services );

	$new_input_date = ovabrw_new_input_date( $id_product, strtotime( $start_date ), strtotime( $end_date ), $id_package, $pickup_loc, $dropoff_loc );

	$pickup_date_new 	= $new_input_date['pickup_date_new'];
	$pickoff_date_new 	= $new_input_date['pickoff_date_new'];
	
	// For Rental Type: Period Time
	$price_type 		= get_post_meta( $id_product, 'ovabrw_price_type', true );
	$rental_info_period = get_rental_info_period( $id_product, $pickup_date_new, $price_type, $id_package );

	$cart_item['product_id'] 			= $id_product;
	$cart_item['ovabrw_number_vehicle'] = 1;
	$cart_item['resources'] 			= $resources_data;
	$cart_item['ovabrw_service'] 		= json_encode( $services_data );
	$cart_item['period_price'] 			= $rental_info_period['period_price'];	
	
	$product_price 	= get_post_meta( $id_product, '_regular_price', true);
	$product_detail = get_real_price_detail( $product_price, $id_product, $pickup_date_new, $pickoff_date_new );

	if( $rental_type == 'period_time' ) {

		if( empty( $start_date ) ) {
			$data = [ 
				'error' => true,
				'start_date' => 'empty',
				'message' => esc_html__('Please Choose Pick-up Date', 'ova-brw'),
			];
		} elseif( empty( $id_package ) ) {
			$data = [ 
				'error' => true,
				'id_package' => 'empty',
				'message' => esc_html__('No Package', 'ova-brw'),
			];
		} else {
	
			$total = get_price_by_date( $id_product, $pickup_date_new, $pickoff_date_new, $cart_item, $pickup_loc, $dropoff_loc, $id_package );
			$total['line_total'] = $total['line_total'];
            $total['product_price'] = $total['line_total'];
			$data = $total;
		}

	} else {
		if( empty( $start_date ) ) {
			$data = [ 
				'error' => true,
				'start_date' => 'empty',
				'message' => esc_html__('Please Choose Pick-up Date', 'ova-brw'),
			];
		} elseif( empty( $end_date ) ) {
			$data = [ 
				'error' => true,
				'end_date' => 'empty',
				'message' => esc_html__('Please Choose Drop-off Date', 'ova-brw'),
			];
		} else {

			$total = get_price_by_date( $id_product, $pickup_date_new, $pickoff_date_new, $cart_item, $pickup_loc, $dropoff_loc, $id_package );

			if( $rental_type == 'hour' ) {
                $total['quantity'] = $total['quantity'] . ' Hours';
            } else if( $rental_type != 'period_time' ) {
                $total['quantity'] = $total['quantity'] . ' Days';
            }
            $total['line_total'] = $total['line_total'];
            $total['product_price'] = $product_detail;
			$data = $total;
		}
	}

	if ( empty( $number_vehicle ) || $number_vehicle < 0 ) {
		$data = [ 
			'error' => true,
			'start_date' => 'empty',
			'message' => esc_html__('Quantity does not exist or is less than 0', 'ova-brw'),
		];
	}

	$data_vehicle = ova_validate_manage_store( $id_product, $pickup_date_new, $pickoff_date_new, $pickup_loc, $dropoff_loc, true, 'search');

	$number_vehicle_available = 0;
	if ( $data_vehicle ) {
		$number_vehicle_available = $data_vehicle['number_vehicle_available'];
		if ( $number_vehicle_available && (int)$number_vehicle_available >= (int)$number_vehicle ) {
			$data['number_vehicle_available'] = (int)$number_vehicle_available;
		} else {
			$data = [
				'error' => true,
				'start_date' => 'empty',
				'message' => esc_html__( "Vehicle is not available for this time, Please book other time.", 'ova-brw' ),
			];
		}
		
	} else {
		$data = [
			'error' => true,
			'start_date' => 'empty',
			'message' => esc_html__( "Vehicle is not available for this time, Please book other time.", 'ova-brw' ),
		];
	}

	if ( isset( $data['line_total'] ) ) {
		$data['line_total'] *= $number_vehicle;
	}

	echo json_encode( $data );

	wp_die();
}


add_action( 'wp_ajax_ovabrw_get_package_by_time', 'ovabrw_get_package_by_time_cus' );
add_action( 'wp_ajax_nopriv_ovabrw_get_package_by_time', 'ovabrw_get_package_by_time_cus' );
function ovabrw_get_package_by_time_cus() {

	$id = isset($_POST['post_id']) ? sanitize_text_field( $_POST['post_id'] ) : '';
	$start_date = isset($_POST['startdate']) ? strtotime( $_POST['startdate'] ) : '';
	
	 // Total Car in the Store
    $total_car_store = ovabrw_get_total_stock( $id );
    
    $post_array_id = ovabrw_get_wpml_product_ids( $id );
    $statuses = brw_list_order_status();
    $orders_ids = ovabrw_get_orders_by_product_id( $id, $statuses );


    $car_using_this_time = array();

    // Get list package of period time
	$ovabrw_petime_id	= get_post_meta( $id, 'ovabrw_petime_id', true );

	$ovabrw_petime_label = get_post_meta( $id, 'ovabrw_petime_label', true );

    // For Order ID
    foreach ($orders_ids as $key => $value) {

        // Get Order Detail by Order ID
        $order = wc_get_order($value);

        // Get Meta Data type line_item of Order
        $order_items = $order->get_items( apply_filters( 'woocommerce_purchase_order_item_types', 'line_item' ) );
       
        // For Meta Data
        foreach ( $order_items as $item_id => $item ) {

            $ovabrw_pickup_date_store = $ovabrw_pickoff_date_store = $id_vehicle = $quantity = '';

            // Check Line Item have item ID is Car_ID
            if( in_array( $item->get_product_id(), $post_array_id ) ){

                // Check time to Prepare before delivered
                $prepare_time = get_post_meta( $id, 'ovabrw_prepare_vehicle', true ) ? get_post_meta( $id, 'ovabrw_prepare_vehicle', true ) * 60 : 0;


                // Get value of pickup date, pickoff date
                foreach ( $item->get_formatted_meta_data() as $meta_id => $meta ) {
                    if( $meta->key == 'ovabrw_pickup_date' ){
                        $ovabrw_pickup_date_store = strtotime( $meta->value );
                    }
                    if( $meta->key == 'ovabrw_pickoff_date' ){
                        $ovabrw_pickoff_date_store = strtotime( $meta->value ) + $prepare_time;
                    }
                    if( $meta->key == 'id_vehicle' ){
                        $id_vehicle = trim( $meta->value );
                    }
                    if( $meta->key == 'ovabrw_number_vehicle' ){
                        $quantity = intval( $meta->value );
                    }
                }

                // Only compare date when "PickOff Date in Store" > "Current Time" becaue "PickOff Date Rent" have to > "Current Time"
                if( $ovabrw_pickoff_date_store >= current_time( 'timestamp' ) && ( $id_vehicle != '' || $quantity ) ){
                    
				    if( $ovabrw_petime_id ){ 
				        foreach ( $ovabrw_petime_id as $petime_id ) {

				        	$start_end_time_package = get_rental_info_period( $id, $start_date, 'period_time', $petime_id );
				        	$ovabrw_pickup_date = $start_end_time_package['start_time'];
				        	$ovabrw_pickoff_date = $start_end_time_package['end_time'];

				        	// Check rent time
		                    if( ! ($ovabrw_pickoff_date <= $ovabrw_pickup_date_store || $ovabrw_pickoff_date_store <= $ovabrw_pickup_date ) ){
		                    	for($i = 0; $i < $quantity; $i++ ) {
		                    		array_push( $car_using_this_time, $petime_id );
		                    	}
		                        
		                    }

				        }
				    }
                    

                }
                
            }

        }

    }

    // Package available
    $pack_avail = array();

    if( $ovabrw_petime_id ){ 
		foreach ( $ovabrw_petime_id as $key => $petime_id ) {

			$i = 0;
			foreach ($car_using_this_time as $v) {
				if( $petime_id == $v ){
					$i ++;
				}
			}
			if( $i < $total_car_store ){

				$pack_avail[ $petime_id ] = $ovabrw_petime_label[$key];
				
			} 
			
		}
	}

	if ( empty( $pack_avail ) ) {
		$pack_avail = array( esc_html__( 'This time is unavailable.', 'ova-brw' ) );
	}
	
	echo json_encode( $pack_avail );

	wp_die();
}



add_action( 'wp_ajax_ovabrw_calculate_total', 'ovabrw_calculate_total', 10, 0 );
add_action( 'wp_ajax_nopriv_ovabrw_calculate_total', 'ovabrw_calculate_total', 10, 0 );
function ovabrw_calculate_total() {

	$id = isset($_POST['id']) ? sanitize_text_field( $_POST['id'] ) : '';

	$pickup_loc = isset($_POST['pickup_loc']) ? sanitize_text_field( $_POST['pickup_loc'] ) : '';
	$dropoff_loc = isset($_POST['dropoff_loc']) ? sanitize_text_field( $_POST['dropoff_loc'] ) : '';

	$pickup_date = isset($_POST['pickup_date']) ? sanitize_text_field( $_POST['pickup_date'] ) : '';
	$dropoff_date = isset($_POST['dropoff_date']) ? sanitize_text_field( $_POST['dropoff_date'] ) : '';
	$package_id = isset($_POST['package_id']) ? sanitize_text_field( $_POST['package_id'] ) : '';

	$quantity = isset($_POST['quantity']) ? sanitize_text_field( $_POST['quantity'] ) : 1;

	$deposit = isset($_POST['deposit']) ? sanitize_text_field( $_POST['deposit'] ) : '';

	$resources = isset($_POST['resources']) ? str_replace( '\\', '', $_POST['resources'] )  : '';

	$services = isset($_POST['services']) ? str_replace( '\\', '', $_POST['services'] )  : '';

	$services_array = (array) json_decode( $services );

	// Get new date
	$new_date = ovabrw_new_input_date( $id, strtotime($pickup_date), strtotime($dropoff_date), $package_id, $pickup_loc, $dropoff_loc );

	// For Rental Type: Period Time
	$price_type = get_post_meta( $id, 'ovabrw_price_type', true );
	$rental_info_period = get_rental_info_period( $id, $new_date['pickup_date_new'], $price_type, $package_id );

	$cart_item['product_id'] = $id;
	$cart_item['ovabrw_number_vehicle'] = $quantity;
	$cart_item['resources'] = (array) json_decode( $resources );
	$cart_item['ovabrw_service'] = json_encode( $services_array );
	$cart_item['period_price'] = $rental_info_period['period_price'];
	$cart_item['ova_type_deposit'] = $deposit;

	$total = get_price_by_date( $id, $new_date['pickup_date_new'], $new_date['pickoff_date_new'], $cart_item, $pickup_loc, $dropoff_loc, $package_id );
	$line_total = $total['line_total'];

	// Calculate When choose Deposit or Full Amonunt at fronend
	$sub_deposit_amount = $line_total;

	/**
	 * Check Vehicle availables
	 */

	// Check product in order
	$store_vehicle_rented = ovabrw_vehicle_rented_in_order( $id, $new_date['pickup_date_new'], $new_date['pickoff_date_new'] );

	// Check product in cart
	$cart_vehicle_rented  = ovabrw_vehicle_rented_in_cart( $id, 'cart', $new_date['pickup_date_new'], $new_date['pickoff_date_new'] );

	// Get manage store
	$manage_store = get_post_meta( $id, 'ovabrw_manage_store', true );

	// Get array vehicle available
    $data_vehicle = ovabrw_get_vehicle_available($id, $store_vehicle_rented, $cart_vehicle_rented, $quantity, $manage_store, $new_date['pickup_date_new'], $new_date['pickoff_date_new'], $pickup_loc, $dropoff_loc, false, $validate = 'cart' );

    // Number vehicle available
    $total['number_vehicle_available'] = $data_vehicle['number_vehicle_available'];

    // Deposit
    $deposit_enable = get_post_meta ( $id, 'ovabrw_enable_deposit', true );

    if ( $deposit_enable === 'yes' && apply_filters( 'ovabrw_ajax_deposit_enable', true ) ) {

    	$value_deposit = ! empty( get_post_meta ( $id, 'ovabrw_amount_deposit', true ) ) ? floatval( get_post_meta ( $id, 'ovabrw_amount_deposit', true ) ) : 0;

    	$deposit_type  = get_post_meta ( $id, 'ovabrw_type_deposit', true );

    	if ( $deposit === 'deposit' ) {

    		if ( $deposit_type === 'percent' ) {
    			$line_total = ( $line_total * $value_deposit ) / 100;
    		} else {
    			$line_total = $value_deposit;
    		}
    	}
    }
	
	if( $total['line_total'] <= 0 ) {
		echo 0;	
	}else{
		if ( isset( $total['amount_insurance'] ) && $total['amount_insurance'] > 0 ) {
			$amount_total = $total['line_total'] - $total['amount_insurance'];
			if ( $amount_total > 0 ) {
				$total['line_total'] = wc_price( apply_filters( 'ovabrw_ajax_total_filter', $line_total, $id ) );
				echo json_encode($total);
			} else {
				echo 0;
			}
		} else {
			$total['line_total'] = wc_price( apply_filters( 'ovabrw_ajax_total_filter', $line_total, $id ) );
			echo json_encode($total);
		}
	}

	wp_die();
}

add_action( 'wp_ajax_ovabrw_get_tax_in_cat', 'ovabrw_get_tax_in_cat', 10, 0 );
add_action( 'wp_ajax_nopriv_ovabrw_get_tax_in_cat', 'ovabrw_get_tax_in_cat', 10, 0 );
function ovabrw_get_tax_in_cat(){

	$cat_val = isset( $_POST['cat_val'] ) ?  $_POST['cat_val'] : '';

	$list_tax_values = array();
	
	
	$get_term = get_term_by( 'slug', $cat_val, 'product_cat' );
	$term_id = $get_term->term_id;

	$ovabrw_custom_tax = get_term_meta($term_id, 'ovabrw_custom_tax', true);
			
	if( $ovabrw_custom_tax ){
		foreach ($ovabrw_custom_tax as $key => $value) {
			if( !in_array($value, $list_tax_values) ){
				if( $value ){
					array_push( $list_tax_values, $value);		

				}
				
			}
			
		}
	}

	echo implode(",", $list_tax_values ); 
	wp_die();

	
}


add_action( 'wp_ajax_ovabrw_get_dropoff_date_transportation', 'ovabrw_get_dropoff_date_transportation' );
add_action( 'wp_ajax_nopriv_ovabrw_get_dropoff_date_transportation', 'ovabrw_get_dropoff_date_transportation' );
function ovabrw_get_dropoff_date_transportation() {

	$date_format = ovabrw_get_date_format();
    $time_format = ovabrw_get_time_format_php();

	$id_product 	= isset($_POST['id_product']) ? sanitize_text_field( $_POST['id_product'] ) : '';
	$pickup_date 	= isset($_POST['pickup_date']) ? strtotime(sanitize_text_field( $_POST['pickup_date'] )) : '';
	
	$pickup_loc 	= isset($_POST['pickup_loc']) ? sanitize_text_field( $_POST['pickup_loc'] ) : '';
	$dropoff_loc 	= isset($_POST['dropoff_loc']) ? sanitize_text_field( $_POST['dropoff_loc'] ) : '';


	$time_dropoff = ovabrw_get_time_by_pick_up_off_loc_transport( $id_product, $pickup_loc, $dropoff_loc );

    // Get Second
    $time_dropoff_seconds = 60 * $time_dropoff;
    
    $dropoff_date_timestamp =  $pickup_date + $time_dropoff_seconds;
    $pickoff_date = date( $date_format . ' ' . $time_format, $dropoff_date_timestamp );
	

	if ( $pickoff_date && $pickup_loc && $dropoff_loc ) {
		$data = [
			'error' => false,
			'dropoff' => $pickoff_date
		];
	} else {
		$data = [
			'error' => true,
			'start_date' => 'empty',
			'message' => esc_html__("Please insert Pick-up, Drop-off Location", 'ova-brw'),
		];
	}
	
	echo json_encode( $data );

	wp_die();
}

/**
 * ajax search map
 */
add_action( 'wp_ajax_ovabrw_search_ajax', 'ovabrw_search_ajax' );
add_action( 'wp_ajax_nopriv_ovabrw_search_ajax', 'ovabrw_search_ajax' );
function ovabrw_search_ajax() {
	$data = $_POST;

	$categories 	= isset( $data['categories'] ) 	? (array)$data['categories'] 					: array();
	$order 			= isset( $data['order'] ) 		? sanitize_text_field( $data['order'] ) 		: '';
	$orderby 		= isset( $data['orderby'] ) 	? sanitize_text_field( $data['orderby'] ) 		: '';
	$per_page 		= isset( $data['per_page'] ) 	? sanitize_text_field( $data['per_page'] ) 		: '';
	$paged 			= isset( $data['paged'] ) 		? (int)$data['paged']  							: 1;
	$name 			= isset( $data['name'] ) 		? sanitize_text_field( $data['name'] ) 			: '';
	$category 		= isset( $data['cat'] ) 		? sanitize_text_field( $data['cat'] ) 			: '';
    $pickup_date 	= isset( $data['start_date'] )  ? strtotime( $data['start_date'] ) 				: '';
    $pickoff_date 	= isset( $data['end_date'] ) 	? strtotime( $data['end_date'] ) 				: '';
    $adults 		= isset( $data['adults'] ) 		? sanitize_text_field( $data['adults'] )		: '';
    $childrens 		= isset( $data['childrens'] ) 	? sanitize_text_field( $data['childrens'] )		: '';

    $args_base = array(
		'post_type'      	=> 'product',
		'post_status'    	=> 'publish',
		'posts_per_page' 	=> -1,
		'order' 			=> $order,
		'orderby' 			=> $orderby,
		'fields'			=> 'ids',
		'tax_query' 		=> array(
            array(
                'taxonomy' => 'product_type',
                'field'    => 'slug',
                'terms'    => 'ovabrw_car_rental', 
            ),
        ),
	);

	$item_ids = $args_adults = $args_childrens = $args_categories = array();

    // Query Adults
    if ( $adults ) {
    	$args_adults = array(
			'meta_query' => array(
				array(
					'key' 		=> 'ovabrw_adult_number',
					'value' 	=> $adults,
					'type'  	=> 'numeric',
					'compare' 	=> '>='
				),
			)
		);
    }

    // Query Childrens
    if ( $childrens ) {
    	$args_childrens = array(
			'meta_query' => array(
				array(
					'key' 		=> 'ovabrw_children_number',
					'value' 	=> $childrens,
					'type'  	=> 'numeric',
					'compare' 	=> '>='
				),
			)
		);
    }

    // Query Categories
    if ( $categories ) {
    	$args_categories = array(
    		'tax_query' => array(
				array(
					'taxonomy' 	=> 'product_cat',
					'field'    	=> 'term_id',
					'terms'    	=> $categories,
					'operator'  => 'IN',
				),
			)
    	);
    }

	$args = array_merge_recursive( $args_base, $args_adults, $args_childrens, $args_categories );

	// Get All products
    $items = new WP_Query( apply_filters( 'ovabrw_ft_items_query_search_map', $args, $data ));

    if ( $items->have_posts() ) : while ( $items->have_posts() ) : $items->the_post();

        // Product ID
        $id = get_the_id();

        // Set Pick-up, Drop-off Date again
        $new_input_date 	= ovabrw_new_input_date( $id, $pickup_date, $pickoff_date, '', '', '' );

        $pickup_date_new 	= $new_input_date['pickup_date_new'];
        $pickoff_date_new 	= $new_input_date['pickoff_date_new'];

        $ova_validate_manage_store = ova_validate_manage_store( $id, $pickup_date_new, $pickoff_date_new, '', '', $passed = false, $validate = 'search' ) ;
        
        if ( $ova_validate_manage_store && $ova_validate_manage_store['status'] ){
            array_push( $item_ids, $id );
        }

    endwhile; else :

        $result = '<div class="not_found_product">'. esc_html__( 'Not found yacht', 'ova-brw' ) .'</div>';

    endif; wp_reset_postdata();

    if ( $item_ids ) {

        $args_product = array(
            'post_type' 		=> 'product',
            'posts_per_page' 	=> $per_page,
            'paged' 			=> $paged,
            'post_status' 		=> 'publish',
            'order' 			=> $order,
			'orderby' 			=> $orderby,
            'post__in' 			=> $item_ids
        );

        $products = new WP_Query( apply_filters( 'ovabrw_ft_query_search_map', $args_product, $data ));

        ob_start();
        ?>

        <div class="ovabrw_product_archive">
			<?php
				do_action( 'woocommerce_before_single_product' );
				if ( $products->have_posts() ) : while ( $products->have_posts() ) : $products->the_post();
					ovabrw_get_template( 'single/ovabrw_single_yacht2.php', $data );
				endwhile; else :
				?>
					<div class="not_found_product"><?php esc_html_e( 'Not found yacht', 'ova-brw' ); ?></div>
				<?php
				endif; wp_reset_postdata();
				do_action( 'woocommerce_after_single_product' );
			?>
		</div>

        <?php

        $total = $products->max_num_pages;

		if (  $total > 1 ): ?>
			<div class="ovabrw-pagination-ajax">
			<?php
				echo ovabrw_pagination_ajax( $products->found_posts, $products->query_vars['posts_per_page'], $paged );
			?>
			</div>
			<?php
		endif;

		$result = ob_get_contents(); 
		ob_end_clean();

		echo json_encode( array( "result" => $result ));
		wp_die();
    } else {
    	echo json_encode( array( "result" => $result ));
    	wp_die();
    }
}

/**
 * ajax ovabrw_show_yacht_detail
 */
add_action( 'wp_ajax_ovabrw_show_yacht_detail', 'ovabrw_show_yacht_detail' );
add_action( 'wp_ajax_nopriv_ovabrw_show_yacht_detail', 'ovabrw_show_yacht_detail' );
function ovabrw_show_yacht_detail() {
	$data 			= $_POST;
	$yacht_id 		= isset( $data['yacht_id'] )  	? (int)( $data['yacht_id'] ) 					: '';
	$pickup_date 	= isset( $data['start_date'] )  ? $data['start_date'] 							: '';
    $pickoff_date 	= isset( $data['end_date'] ) 	? $data['end_date'] 							: '';
    $adults 		= isset( $data['adults'] ) 		? sanitize_text_field( $data['adults'] )		: '';
    $childrens 		= isset( $data['childrens'] ) 	? sanitize_text_field( $data['childrens'] )		: '';
    $package_time 	= isset( $data['package_time'] ) ? sanitize_text_field( $data['package_time'] )	: '';

    $date_format = ovabrw_get_date_format();
	$time_format = ovabrw_get_time_format_php();

	$rental_type = get_post_meta( $yacht_id, 'ovabrw_price_type', true );
	$defined_one_day = defined_one_day( $yacht_id );

	$date_time_format = $date_format . ' ' . $time_format;
	if ( $rental_type == 'period_time' || $defined_one_day === 'hotel' ) {
		$date_time_format = $date_format;
	}

	$new_time = get_date_from_package( $package_time, $pickup_date );
	if ( $new_time['pickup_date'] ) {
		$pickup_date = date( $date_time_format, $new_time['pickup_date'] );
	}
	if ( $new_time['pickoff_date'] ) {
		$pickoff_date = date( $date_time_format, $new_time['pickoff_date'] );
	}

	if ( $pickup_date ) {
		$pickup_date 	= date( $date_time_format, strtotime( $pickup_date ) );
	}
	if ( $pickoff_date ) {
		$pickoff_date 	= date( $date_time_format, strtotime( $pickoff_date ) );
	}

	// Show booking & request forms
	$show_booking_form = get_option( 'ova_brw_template_show_booking_form', 'yes' );
	$show_request_form = get_option( 'ova_brw_template_show_request_booking', 'yes' );

    if ( $yacht_id ) {
    	$product 			= wc_get_product( $yacht_id );
		$gallery_ids 		= $product->get_gallery_image_ids();
    	$link 				= get_permalink( $yacht_id );
	    $price          	= get_post_meta( $yacht_id, '_regular_price', true );
		$children_number 	= get_post_meta( $yacht_id, 'ovabrw_children_number', true );
		$adult_number      	= get_post_meta( $yacht_id, 'ovabrw_adult_number', true );
		ob_start();
    ?>
    	<div class="modal-container">
			<div class="modal modal-booking-tab">
				<!-- yacht Booking -->
				<div class="modal-popup-close">
					<i class="ovaicon-cancel"></i>
				</div>
				<div class="yacht-tabs">	
					<div class="forms-booking-tab">
						<?php if ( $show_booking_form === 'yes' && $show_request_form === 'yes' ): ?>
							<ul class="tabs">
								<li class="item booking active" data-form="ovabrw_booking_form"><?php echo esc_html__( 'Booking', 'ova-brw' ); ?></li>
								<li class="item request-booking" data-form="request_booking"><?php echo esc_html__( 'Request Booking', 'ova-brw' ); ?></li>
							</ul>
							<?php ovabrw_get_template( 'single/booking-form.php', array('id' => $yacht_id) ); ?>
							<?php ovabrw_get_template( 'single/request_booking.php', array('id' => $yacht_id) ); ?>
						<?php elseif ( $show_booking_form === 'yes' ): ?>
							<ul class="tabs">
								<li class="item booking active" data-form="ovabrw_booking_form"><?php echo esc_html__( 'Booking', 'ova-brw' ); ?></li>
							</ul>
							<?php ovabrw_get_template( 'single/booking-form.php', array('id' => $yacht_id) ); ?>
						<?php elseif ( $show_request_form === 'yes' ): ?>
							<ul class="tabs">
								<li class="item request-booking active" data-form="request_booking">
									<?php echo esc_html__( 'Request Booking', 'ova-brw' ); ?>
								</li>
							</ul>
							<?php ovabrw_get_template( 'single/request_booking.php', array('id' => $yacht_id) ); ?>
						<?php endif; ?>
					</div>
				</div><!-- End yacht Booking -->
			</div>
		</div>

    <?php
    	$result = ob_get_contents(); 
		ob_end_clean();

		echo json_encode( array(
			"result" 		=> $result,
			"pickup_date" 	=> $pickup_date,
			"pickoff_date" 	=> $pickoff_date
		));
		wp_die();
	} else {
		$result = '<div class="not_found_product">'. esc_html__( 'Not found yacht', 'ova-brw' ) .'</div>';
		echo json_encode( array( "result" => $result ) );
    	wp_die();
	}
}

add_action( 'wp_ajax_ovabrw_search_ajax_validation_booking_form', 'ovabrw_search_ajax_validation_booking_form' );
add_action( 'wp_ajax_nopriv_ovabrw_search_ajax_validation_booking_form', 'ovabrw_search_ajax_validation_booking_form' );
function ovabrw_search_ajax_validation_booking_form() {
	$data 			= $_POST;
	$yacht_id 		= isset( $data['yacht_id'] )  	? (int)( $data['yacht_id'] ) 				  : '';
	$check_in 		= isset( $data['check_in'] )  	? strtotime( $data['check_in'] ) 			  : '';
    $check_out 		= isset( $data['check_out'] ) 	? strtotime( $data['check_out'] ) 			  : '';
    $pickup_loc 	= isset( $data['pickup_loc'] ) 	? sanitize_text_field( $data['pickup_loc'] )  : '';
    $pickoff_loc 	= isset( $data['pickoff_loc'] ) ? sanitize_text_field( $data['pickoff_loc'] ) : '';
    $adults 		= isset( $data['adults'] ) 		? (int)$data['adults']						  : '';
    $childrens 		= isset( $data['childrens'] ) 	? (int)$data['childrens']					  : '';
    $yachts 		= isset( $data['yachts'] ) 		? (int)$data['yachts']						  : 1;
    $services 		= isset( $data['services']) 	? str_replace( '\\', '', $data['services'] )  : '';
    $package_id 	= isset( $data['package_id'] )  ? sanitize_text_field( $data['package_id'] ) : '';

    $services 		= (array) json_decode( $services );

    // Retal type
    $rental_type 	= get_post_meta( $yacht_id, 'ovabrw_price_type', true );

    // Max adults, childrens
    $max_adults     = (int)get_post_meta( $yacht_id, 'ovabrw_adult_number', true );
    $max_childrens  = (int)get_post_meta( $yacht_id, 'ovabrw_children_number', true );

    // Rent day min
    $day_min 		= (int)get_post_meta( $yacht_id, 'ovabrw_rent_day_min', true );

    // Rent hour min
    $hour_min 		= (int)get_post_meta( $yacht_id, 'ovabrw_rent_hour_min', true );

    $new_date 		= ovabrw_new_input_date( $yacht_id, $check_in, $check_out, $package_id, $pickup_loc, $pickoff_loc );
    $check_in_new 	= $new_date['pickup_date_new'];
    $check_out_new 	= $new_date['pickoff_date_new'];

    $data = array();

    $service_required = get_post_meta( $yacht_id, 'ovabrw_service_required', true );

    if ( $service_required ) {
        foreach ($service_required as $key => $value) {
            if( $value == 'yes' ){
                if ( ! ( isset( $services[$key] ) && $services[$key] ) ) {
                    $data = array(
			    		'error' 	=> true,
			    		'message' 	=> esc_html( "Please choose Extra Service", 'ova-brw' )
			    	);
                    break;
                }
            }
        }
    }

    if ( $yachts < 1 ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Please choose yachts greater 0", 'ova-brw' )
    	);
    } else if ( $adults < 1 ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Please choose the number of adults greater 0", 'ova-brw' )
    	);
    } else if ( $adults > $max_adults ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> sprintf( esc_html__( 'Please choose the number of adults less than %d', 'ova-brw' ), $max_adults )
    	);
    } else if ( $childrens > $max_childrens ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> sprintf( esc_html__( 'Please choose the number of childrens less than %d', 'ova-brw' ), $max_childrens )
    	);
    } else if ( empty( $check_in_new ) || empty( $check_out_new ) ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Please insert Check in, Check out date", 'ova-brw' )
    	);
    } else if ( $check_in_new < current_time('timestamp') ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Check in must be greater than Current Time", 'ova-brw' )
    	);
    } else if ( $check_in_new >  $check_out_new ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html( "Check out must be greater than Check in", 'ova-brw' )
    	);
    } else {
    	$data = array(
    		'error' 	=> false
    	);
    }

    switch( $rental_type ) {
        case 'day':
	        if ( ovabrw_val_day_min( $check_out_new, $check_in_new, $day_min ) ){
	            $data = array(
		    		'error' 	=> true,
		    		'message' 	=> sprintf( esc_html__( 'Min Rental Period: %d day', 'ova-brw' ), $day_min )
		    	);
	        }
	        break;
        case 'hour':
	        if ( ovabrw_val_hour_min( $check_out_new, $check_in_new, $hour_min ) ) {
	        	$data = array(
		    		'error' 	=> true,
		    		'message' 	=> sprintf( esc_html__( 'Min Rental Hours %d hour', 'ova-brw' ), $hour_min )
		    	);
	        }
        	break;
        case 'mixed':
	        if ( ovabrw_val_hour_min( $check_out_new, $check_in_new, $hour_min ) ){
	        	$data = array(
		    		'error' 	=> true,
		    		'message' 	=> sprintf( esc_html__( 'Min Rental Hours %d hour', 'ova-brw' ), $hour_min )
		    	);
	        }
	        break;
    }

    $untime_startdate = get_post_meta( $yacht_id, 'ovabrw_untime_startdate', true );
    $untime_enddate   = get_post_meta( $yacht_id, 'ovabrw_untime_enddate', true );

    if ( $untime_startdate ) {
        foreach ( $untime_startdate as $key => $value ) {
            if ( ! ( $check_out_new < strtotime( $untime_startdate[$key] ) || strtotime( $untime_enddate[$key] ) < $check_in_new ) ) {
            	$data = array(
		    		'error' 	=> true,
		    		'message' 	=> esc_html__( 'This time is not available for renting', 'ova-brw' )
		    	);
            }
        }
    }

    $disable_week_day      = get_option( 'ova_brw_calendar_disable_week_day', '' );
    $data_disable_week_day = $disable_week_day != '' ? explode( ',', $disable_week_day ) : '';

    if ( $data_disable_week_day && $check_in_new && $check_out_new ) {
    	if ( apply_filters( 'ovabrw_allow_boooking_incl_disable_week_day', false ) ) {
    		$pickup_date_of_week    = date('w', $check_in_new );
            $dropoff_date_of_week   = date('w', $check_out_new );

            if ( in_array( $pickup_date_of_week, $data_disable_week_day ) || in_array( $dropoff_date_of_week, $data_disable_week_day ) ) {
                $data = array(
		    		'error' 	=> true,
		    		'message' 	=> esc_html__( 'This time is not available for renting', 'ova-brw' )
		    	);
            }
    	} else {
    		$datediff       = (int)$check_out_new - (int)$check_in_new;
	        $total_datediff = round( $datediff / (60 * 60 * 24), wc_get_price_decimals() ) + 1;

	        // get number day
	        $pickup_date_of_week   = date('w', $check_in_new );
	        $pickup_date_timestamp = $check_in_new;
	        
	        $i = 0;

	        while ( $i <= $total_datediff ) {
	            if ( in_array( $pickup_date_of_week, $data_disable_week_day ) ) {
	                $data = array(
			    		'error' 	=> true,
			    		'message' 	=> esc_html__( 'This time is not available for renting', 'ova-brw' )
			    	);
	            }

	            $pickup_date_of_week  = date('w', $pickup_date_timestamp );
	            
	            $pickup_date_timestamp = strtotime('+1 day', $pickup_date_timestamp);

	            $i++;
	        }
    	}
    }

    $manage_store = get_post_meta( $yacht_id, 'ovabrw_manage_store', true );

    // Check Count Product in Order
    $in_store = ovabrw_vehicle_rented_in_order( $yacht_id, $check_in_new, $check_out_new );
    
    // Check Count Product in Cart
    $in_cart  = ovabrw_vehicle_rented_in_cart( $yacht_id, 'cart', $check_in_new, $check_out_new );

    $total_car_store = (int)get_post_meta( $yacht_id, 'ovabrw_car_count', true );

    $yachts_available = $total_car_store - $in_store - $in_cart;

    if ( $yachts_available < $yachts ) {
        $data = array(
    		'error' 	=> true,
    		'message' 	=> sprintf( esc_html__( 'Available yachts is %s', 'ova-brw'  ), $yachts_available )
    	);
    }

    if ( $yachts_available < 0 || $yachts_available == 0 ) {
    	$data = array(
    		'error' 	=> true,
    		'message' 	=> esc_html__( 'Yachts isn\'t available for this time, Please book other time.', 'ova-brw' )
    	);
    }

    echo json_encode( $data );

	wp_die();
}

// Verify recaptcha
add_action( 'wp_ajax_ovabrw_verify_recaptcha', 'ovabrw_verify_recaptcha' );
add_action( 'wp_ajax_nopriv_ovabrw_verify_recaptcha', 'ovabrw_verify_recaptcha' );
if ( !function_exists( 'ovabrw_verify_recaptcha' ) ) {
	function ovabrw_verify_recaptcha() {
		$token 	= isset( $_POST['token'] ) ? $_POST['token'] : '';
		$mesg 	= '';

		if ( 'v2' == ovabrw_recaptcha_get_type() ) {
			$mesg = ovabrw_verify_recaptcha_v2( $token );
		} elseif ( 'v3' == ovabrw_recaptcha_get_type() ) {
			$mesg = ovabrw_verify_recaptcha_v3( $token );
		}

		echo esc_html( $mesg );
		wp_die();
	}
}

?>