<?php if ( ! defined( 'ABSPATH' ) ) exit();

if ( ! class_exists( 'Ovabrw_Settings' ) ) {
    class Ovabrw_Settings {
        public function __construct() {
			add_filter( 'woocommerce_get_settings_pages', array( $this, 'ovabrw_add_settings_tab' ), 10, 1 );

			// Before field
			add_action( 'woocommerce_admin_field_ovabrw_before', array( $this, 'ovabrw_admin_field_before' ) );

			// After field
			add_action( 'woocommerce_admin_field_ovabrw_after', array( $this, 'ovabrw_admin_field_after' ) );
        }

        public function ovabrw_add_settings_tab( $settings ) {
		  	$settings[] = include( OVABRW_PLUGIN_PATH.'/admin/setting/ovabrw-settings-tab.php' );  

		  	return $settings;
		}

		/**
		 * Before field
		 * @param  array $value
		 * @return html
		 */
		public function ovabrw_admin_field_before( $value ) {
			do_action( 'ovabrw_admin_field_before', $value );
			?>
			<div id="<?php echo esc_attr( sanitize_title( $value['id'] ) ); ?>" class="<?php echo esc_attr( sanitize_title( $value['class'] ) ); ?>" style="<?php echo esc_attr( $value['css'] ); ?>">
			<?php
		}

		/**
		 * After field
		 * @param  array $value
		 * @return html
		 */
		public function ovabrw_admin_field_after( $value ) {
			?>
			</div>
			<?php
			do_action( 'ovabrw_admin_field_after', $value );
		}
    }
}

new Ovabrw_Settings();