<?php if ( !defined( 'ABSPATH' ) ) exit();

$id = $args['id'];
if ( !$id ) {
	$id = get_the_ID();
}

$avatar       = get_post_meta( $id, 'ova_team_met_avatar', true );
$job          = get_post_meta( $id, 'ova_team_met_job', true );
$email        = get_post_meta( $id, 'ova_team_met_email', true );
$phone        = get_post_meta( $id, 'ova_team_met_phone', true );
$phone_number = preg_replace("/[^0-9]/", "", $phone);
$address      = get_post_meta( $id, 'ova_team_met_address', true );
$link_address = get_post_meta( $id, 'ova_team_met_link_address', true );
$list_social  = get_post_meta( $id, 'ova_team_met_group_icon', true );

$short_desc   = get_post_meta( $id, 'ova_team_met_short_desc', true );

$experience_1       = get_post_meta( $id, 'ova_team_met_experience_1', true );
$experience_2       = get_post_meta( $id, 'ova_team_met_experience_2', true );
$group_experience   = get_post_meta( $id, 'ova_team_met_group_experience', true );
$group_achievements = get_post_meta( $id, 'ova_team_met_group_achievements', true );
$group_education    = get_post_meta( $id, 'ova_team_met_group_education', true ); 
$group_language     = get_post_meta( $id, 'ova_team_met_group_language', true );

?>

<div class="info">

	<div class="bio">

		<h2 class="name">
			<?php echo get_the_title() ;?>
		</h2>

		<?php if( ! empty( $job ) ) { ?>
			<div class="job">
				<?php echo esc_html( $job ); ?>
			</div>
		<?php } ?>

		<!-- Image -->
		<div class="img">
			<?php if( ! empty( $avatar ) ){ ?>
				<img src="<?php echo esc_url( $avatar ); ?>" class="img-responsive" alt="<?php echo get_the_title(); ?>">
			<?php } ?>

			 <!-- Social Icon -->
			<?php if( ! empty( $list_social ) ) {  ?>
				<ul class="social">
					<?php
						foreach( $list_social as $social ){

							$class_icon = isset( $social['ova_team_met_class_icon_social'] ) ? $social['ova_team_met_class_icon_social'] : '';
							$link_social = isset( $social['ova_team_met_link_social'] ) ? $social['ova_team_met_link_social'] : '';
							?>
							<li>
								<a href="<?php echo esc_url( $link_social ); ?>" title="<?php echo esc_url( $link_social ); ?>" target="_blank">
									<i class="<?php echo esc_attr( $class_icon ); ?>"></i>
								</a>
							</li>
					<?php } ?>
					
				</ul>
			<?php } ?>
		</div>  

		<!-- Contact -->
		<div class="contact-content">

			<?php if( ! empty( $phone ) ) { ?>
				<div class="contact phone">
					<div class="icon">
						<i class="icomoon icomoon-phone"></i>
					</div>
					<div class="label-phone">
						<span class="label">
							<?php echo esc_html_e('Phone number','ova-team');?>
						</span>
						<a href="tel:<?php echo esc_attr( $phone_number ); ?>" >
							<?php echo esc_html( $phone ); ?>
						</a>
					</div>
				</div>
			<?php } ?>

			<?php if( ! empty( $email ) ) { ?>
				<div class="contact email">
					<div class="icon">
						<i class="icomoon icomoon-mail"></i>	
					</div>
					<div class="label-phone">
						<span class="label">
							<?php echo esc_html_e('Email','ova-team'); ?>
						</span>
						<a href="mailto:<?php echo esc_attr( $email ); ?>" >
							<?php echo esc_html( $email ); ?>
						</a>
					</div>	
				</div>
			<?php } ?>

			<?php if( ! empty( $address ) ) { ?>
				<div class="contact address">
					<div class="icon">
						<i class="icomoon icomoon-address"></i>		
					</div>
					<div class="label-phone">
						<span class="label">
							<?php echo esc_html_e('Address','ova-team'); ?>
						</span>
						<?php if( ! empty( $link_address ) ) { ?>
							<a href="<?php echo esc_url( $link_address ); ?>" target="_blank">
								<?php echo esc_html( $address ); ?>
							</a>
					    <?php } ?>
					</div>
				</div>
			<?php } ?>

		</div>
		
	</div>

	<div class="main_content">

		<!-- Short Description -->
		<?php if( ! empty( $short_desc ) ){ ?>
			<div class="short-description">
				<div class="content">
					<?php printf( $short_desc ); ?>
				</div>
			</div>
		<?php } ?>

        <!--  Achievements -->
		<?php if( ! empty( $group_achievements ) ) {  ?>
			<div class="achievements">
				<h3 class="heading">
					<?php echo esc_html__('Achievements', 'ova-team'); ?>
				</h3>
				<?php
					foreach( $group_achievements as $achi ){
                        $achi_topic   = isset( $achi['ova_team_met_achi_topic'] ) ? $achi['ova_team_met_achi_topic'] : ''; 
						$achi_percent = isset( $achi['ova_team_met_achi_percent'] ) ? $achi['ova_team_met_achi_percent'] : ''; 
					?>
					<div class="topic-percent">
						<span class="topic">
							<?php echo esc_html($achi_topic . ':'); ?>
						</span>
						<span class="percent">
						    <?php echo esc_html($achi_percent . '%' ); ?>
						</span>
					</div>
					<div class="progress-bar">
						<div class="percent-view" data-percent="<?php echo esc_attr( $achi_percent ); ?>"></div>
					</div>
				<?php } ?>
			</div>
		<?php } ?>

        <!--  Experience short desc 1 -->
		<?php if( ! empty( $experience_1 ) ) { ?>
			<div class="experience-1">
				<h3 class="heading heading-exp">
					<?php echo esc_html__('Experience', 'ova-team') ?>
				</h3>
				<p>
					<?php echo esc_html( $experience_1 ) ?>
				</p>
			</div>
		<?php } ?>

        <!--  Experience -->
		<?php if( ! empty( $group_experience ) ) {  ?>
			<ul class="experience-list">
				<?php
					foreach( $group_experience as $exp ){
                        $exp_year = isset( $exp['ova_team_met_exp_year'] ) ? $exp['ova_team_met_exp_year'] : ''; 
						$exp_desc = isset( $exp['ova_team_met_exp_desc'] ) ? $exp['ova_team_met_exp_desc'] : ''; 
					?>
						<li class="experience-list-item">
							<div class="year">
								<?php echo esc_html($exp_year); ?>
							</div>
							<div class="desc">
								<?php printf($exp_desc); ?>
							</div>
						</li>
				<?php } ?>
				
			</ul>
		<?php } ?>

        <!--  Experience short desc 2 -->
		<?php if( ! empty( $experience_2 ) ) { ?>
			<div class="experience-2">
				<p>
					<?php echo esc_html( $experience_2 ) ?>
				</p>
			</div>
		<?php } ?>

		
	</div>
</div>