<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>
<li <?php wc_product_class( 'ova-product', $product ); ?>>
	<?php
	/**
	 * Hook: yachbat_wc_before_shop_loop_item.
	 */
	do_action( 'yachbat_wc_before_shop_loop_item' );

	/**
	 * Hook: yachbat_wc_before_head_loop_item.
	 */
	do_action( 'yachbat_wc_before_head_loop_item' );

	/**
	 * Hook: yachbat_wc_head_loop_item.
	 *
	 * @hooked yachbat_template_head_loop_product_favourite - 10
	 * @hooked yachbat_template_head_loop_product_features - 10
	 * @hooked yachbat_template_head_loop_product_thumbnail - 10
	 */
	do_action( 'yachbat_wc_head_loop_item', $args );

	/**
	 * Hook: yachbat_wc_after_head_loop_item.
	 */
	do_action( 'yachbat_wc_after_head_loop_item' );

	/**
	 * Hook: yachbat_wc_before_foot_loop_item.
	 */
	do_action( 'yachbat_wc_before_foot_loop_item' );

	/**
	 * Hook: yachbat_wc_foot_loop_item.
	 *
	 * @hooked yachbat_template_foot_loop_product_title - 10
	 * @hooked yachbat_template_head_loop_product_price - 10
	 * @hooked yachbat_template_foot_loop_product_review - 10
	 * @hooked yachbat_template_foot_loop_product_custom_taxonomies - 10
	 * @hooked yachbat_template_foot_loop_product_location - 10
	 */
	do_action( 'yachbat_wc_foot_loop_item', $args );

	/**
	 * Hook: yachbat_wc_after_foot_loop_item.
	 */
	do_action( 'yachbat_wc_after_foot_loop_item' );

	/**
	 * Hook: yachbat_wc_after_shop_loop_item.
	 */
	do_action( 'yachbat_wc_after_shop_loop_item' );
	?>
</li>
