<?php
/**
 * Yachbat\WooCommerce Template Hooks
 *
 * Action/filter hooks used for Yachbat\WooCommerce functions/templates.
 *
 * @package Yachbat\WooCommerce\Templates
 * @version 1.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * yachbat Product Loop Items.
 *
 * @see yachbat_template_before_head_loop_item()
 * @see yachbat_template_head_loop_product_favourite()
 * @see yachbat_template_head_loop_product_thumbnail()
 * @see yachbat_template_head_loop_product_price()
 * @see yachbat_template_after_head_loop_item()
 * 
 * @see yachbat_template_before_foot_loop_item()
 * @see yachbat_template_foot_loop_product_title()
 * @see yachbat_template_foot_loop_product_review()
 * @see yachbat_template_foot_loop_product_custom_taxonomies()
 * @see yachbat_template_foot_loop_product_location()
 * @see yachbat_template_after_foot_loop_item()
 */

add_action( 'yachbat_wc_before_head_loop_item', 'yachbat_template_before_head_loop_item', 10 );
add_action( 'yachbat_wc_head_loop_item', 'yachbat_template_head_loop_product_favourite', 10 );
add_action( 'yachbat_wc_head_loop_item', 'yachbat_template_head_loop_product_thumbnail', 10 );
add_action( 'yachbat_wc_head_loop_item', 'yachbat_template_head_loop_product_featured', 10 );
add_action( 'yachbat_wc_head_loop_item', 'yachbat_template_head_loop_product_features', 10 );
add_action( 'yachbat_wc_after_head_loop_item', 'yachbat_template_after_head_loop_item', 10 );

add_action( 'yachbat_wc_before_foot_loop_item', 'yachbat_template_before_foot_loop_item', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_foot_loop_product_title', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_foot_loop_product_review', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_before_loop_product_price', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_foot_loop_product_price', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_foot_loop_product_button', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_after_loop_product_price', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_foot_loop_product_custom_taxonomies', 10 );
add_action( 'yachbat_wc_foot_loop_item', 'yachbat_template_foot_loop_product_location', 10 );
add_action( 'yachbat_wc_after_foot_loop_item', 'yachbat_template_after_foot_loop_item', 10 );

/**
 * yachbat Single Product.
 *
 * @see yachbat_wc_before_single_product()
 */

add_action( 'yachbat_wc_before_single_product', 'yachbat_wc_template_single_title', 5 );
add_action( 'yachbat_wc_before_single_product', 'yachbat_wc_template_single_price', 5 );
add_action( 'yachbat_wc_template_single_special_price', 'yachbat_wc_template_single_special_price', 10 );
add_action( 'yachbat_wc_template_single_period', 'yachbat_wc_template_single_period', 10 );
add_action( 'yachbat_wc_template_single_day', 'yachbat_wc_template_single_day', 10 );
add_action( 'yachbat_wc_template_single_hour', 'yachbat_wc_template_single_hour', 10 );
add_action( 'yachbat_wc_template_single_weekdays_price', 'yachbat_wc_template_single_weekdays_price', 10 );
add_action( 'yachbat_wc_single_product_summary_left', 'yachbat_wc_template_product_images', 10 );
add_action( 'yachbat_wc_template_product_thumbnails', 'yachbat_wc_template_product_thumbnails', 10 );
add_action( 'yachbat_wc_single_product_summary_left', 'yachbat_wc_template_product_description', 10 );
add_action( 'yachbat_wc_single_product_summary_left', 'yachbat_wc_template_product_location', 15 );
add_action( 'yachbat_wc_single_product_summary_left', 'yachbat_wc_template_product_calendar', 15 );
add_action( 'yachbat_wc_single_product_summary_left', 'yachbat_wc_template_product_policies', 20 );
add_action( 'yachbat_wc_single_product_summary_left', 'yachbat_wc_template_product_tags', 20 );
add_action( 'yachbat_wc_single_product_summary_left', 'yachbat_wc_template_product_review', 20 );

add_action( 'yachbat_wc_single_product_summary_right', 'yachbat_wc_template_product_taxonomy', 10 );
add_action( 'yachbat_wc_single_product_summary_right', 'yachbat_wc_template_product_forms_tab', 10 );
add_action( 'yachbat_wc_template_product_booking_form', 'yachbat_wc_template_product_booking_form', 10 );
add_action( 'yachbat_wc_template_product_request_booking', 'yachbat_wc_template_product_request_booking', 10 );

/* Booking Form */
add_action( 'yachbat_wc_booking_form', 'yachbat_wc_booking_form_fields', 5 );
add_action( 'yachbat_wc_booking_form', 'yachbat_wc_booking_form_extra_fields', 10 );
add_action( 'yachbat_wc_booking_form', 'yachbat_wc_booking_form_services', 15 );
add_action( 'yachbat_wc_booking_form', 'yachbat_wc_booking_form_resource', 20 );
add_action( 'yachbat_wc_booking_form', 'yachbat_wc_booking_form_deposit', 25 );
add_action( 'yachbat_wc_booking_form', 'yachbat_wc_booking_form_ajax_total', 30 );

add_action( 'yachbat_wc_after_single_product', 'yachbat_wc_template_product_related', 20 );