<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly


class Yachbat_Elementor_Contact_Info extends Widget_Base {

	
	public function get_name() {
		return 'yachbat_elementor_contact_info';
	}

	
	public function get_title() {
		return esc_html__( 'Contact Info', 'yachbat' );
	}
	
	public function get_icon() {
		return 'eicon-map-pin';
	}

	public function get_categories() {
		return [ 'yachbat' ];
	}

	public function get_script_depends() {
		return [ '' ];
	}
	
	// Add Your Controll In This Function
	protected function register_controls() {

		/**
		 * Content Tab
		 */
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
				
			]
		);
			$this->add_control(
				'label',
				[
					'label' => esc_html__( 'Label', 'yachbat' ),
					'type' 	=> \Elementor\Controls_Manager::TEXT,
				]
			);

			$repeater = new \Elementor\Repeater();

				$repeater->add_control(
					'type',
					[
						'label'   => esc_html__( 'Type', 'yachbat' ),
						'type' 	  => Controls_Manager::SELECT,
						'default' => 'email',
						'options' => [
							'email' => esc_html__('Email', 'yachbat'),
							'phone' => esc_html__('Phone', 'yachbat'),
							'link' 	=> esc_html__('Link', 'yachbat'),
							'text' 	=> esc_html__('Text', 'yachbat'),
						]
					]
				);
				
				$repeater->add_control(
					'icon_email',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'icomoon icomoon-envelope',
							'library' 	=> 'icomoon',
						],
						'condition' => [
							'type' => 'email',
						]
					]
				);
				
				$repeater->add_control(
					'email_title',
					[
						'label'   		=> esc_html__( 'Email title', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'placeholder'	=> esc_html__( 'Email address', 'yachbat' ),
						'condition' 	=> [
							'type' => 'email',
						]
					]
				);

				$repeater->add_control(
					'email_label',
					[
						'label'   	  => esc_html__( 'Email Label', 'yachbat' ),
						'type'    	  => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( 'email@company.com', 'yachbat' ),
						'default' 	  => 'email@company.com',
						'condition'   => [
							'type' => 'email',
						]

					]
				);

				$repeater->add_control(
					'email_link',
					[
						'label'   	  => esc_html__( 'Email Link', 'yachbat' ),
						'type'    	  => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( 'email@company.com', 'yachbat' ),
						'default'  	  => 'email@company.com',
						'condition'   => [
							'type' => 'email',
						]

					]
				);

				$repeater->add_control(
					'icon_phone',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'condition' => [
							'type' => 'phone',
						]
					]
				);

				$repeater->add_control(
					'phone_title',
					[
						'label'   		=> esc_html__( 'Phone Title', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'Hotline: ', 'yachbat' ),
						'default' 		=> 'Have Any Questions?:',
						'condition' 	=> [
							'type' => 'phone',
						]

					]
				);

				$repeater->add_control(
					'phone_label',
					[
						'label'   		=> esc_html__( 'Phone Label', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( '+012 (345) 678', 'yachbat' ),
						'default' 		=> '+8439 58 41 99',
						'condition' => [
							'type' => 'phone',
						]

					]
				);

				$repeater->add_control(
					'phone_link',
					[
						'label'   	  => esc_html__( 'Phone Link', 'yachbat' ),
						'type'    	  => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( '+012345678', 'yachbat' ),
						'default' 	  => '#',
						'condition'   => [
							'type' => 'phone',
						]

					]
				);

				$repeater->add_control(
					'icon_link',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> '',
							'library' 	=> 'icomoon',
						],
						'condition' => [
							'type' => 'link',
						]
					]
				);

				$repeater->add_control(
					'link_title',
					[
						'label'   		=> esc_html__( 'Link Title', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'Link Title', 'yachbat' ),
						'default' 		=> 'Title link ',
						'condition' 	=> [
							'type' => 'link',
						]

					]
				);
				$repeater->add_control(
					'link_label',
					[
						'label'   		=> esc_html__( 'Link Label', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::TEXT,
						'description' 	=> esc_html__( 'https://your-domain.com', 'yachbat' ),
						'default' 		=> 'https://your-domain.com',
						'condition' 	=> [
							'type' => 'link',
						]

					]
				);

				$repeater->add_control(
					'link_address',
					[
						'label'   		=> esc_html__( 'Link', 'yachbat' ),
						'type'    		=> \Elementor\Controls_Manager::URL,
						'description' 	=> esc_html__( 'https://your-domain.com', 'yachbat' ),
						'show_external' => false,
						'default' 		=> [
							'url' 			=> '#',
							'is_external' 	=> false,
							'nofollow' 		=> false,
						],
						'condition' => [
							'type' => 'link',
						],
					]
				);

				$repeater->add_control(
					'icon_text',
					[
						'label' 	=> esc_html__( 'Choose Icon', 'yachbat' ),
						'type'  	=> Controls_Manager::ICONS,
						'default' 	=> [
							'value' 	=> 'fab fa-readme',
							'library' 	=> 'icomoon',
						],
						'condition' => [
							'type' => 'text',
						]
					]
				);

				$repeater->add_control(
					'text',
					[
						'label'   	  => esc_html__( 'Text', 'yachbat' ),
						'type'    	  => \Elementor\Controls_Manager::TEXT,
						'description' => esc_html__( 'Your text', 'yachbat' ),
						'default' 	  => 'Your text',
						'condition'   => [
							'type' => 'text',
						]

					]
				);

				$this->add_control(
					'items_info',
					[
						'label'       => esc_html__( 'Items Info', 'yachbat' ),
						'type'        => Controls_Manager::REPEATER,
						'fields'      => $repeater->get_controls(),
						'default' => [
							[
								'type' 			=> 'email',
								'email_label' 	=> esc_html__('email@company.com', 'yachbat'),
								'email_address' => esc_html__('email@company.com', 'yachbat'),
							],
						],
						'title_field' => '{{{ type }}}',
					]
				);

		$this->end_controls_section(); 
		// End Content Tab


		/**
		 * Label Style Tab
		 */
		$this->start_controls_section(
			'section_label_style',
			[
				'label' => esc_html__( 'Label', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			
			$this->add_control(
				'label_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .contact .label' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'label_typography',
					'selector'  => '{{WRAPPER}} .ova-contact-info .contact .label',
				]
			);

			$this->add_responsive_control(
				'label_margin',
				[
					'label' 	 => esc_html__( 'Margin', 'yachbat' ),
					'type' 		 => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-contact-info .contact .label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Label Style Tab
		
		/**
		 * Info Style Tab content
		 */
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'link_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .contact .info .item a' => 'color : {{VALUE}};',
						'{{WRAPPER}} .ova-contact-info .contact .info .item:not(i) ' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'link_color_hover',
				[
					'label' 	=> esc_html__( 'Color hover', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .contact .info .item a:hover' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'link_typography',
					'selector'  => '{{WRAPPER}} .ova-contact-info .contact .info .item a',
					'selector'  => '{{WRAPPER}} .ova-contact-info .contact .info .item',
				]
			);

			$this->add_responsive_control(
				'link_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info .contact .info .item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Label Style content label


		/**
		 * Icon Style Tab 
		 */
		$this->start_controls_section(
			'section_icon_style',
			[
				'label' => esc_html__( 'Icon', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

			$this->add_control(
				'icon_fontsize',
				[
					'label' 	 => esc_html__( 'Font Size', 'yachbat' ),
					'type' 		 => Controls_Manager::SLIDER,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' 	=> 1,
							'max' 	=> 300,
							'step' 	=> 1,
						]
					],
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .info .item i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .info .item i' => 'color : {{VALUE}} !important',
					],
				]
			);

			$this->add_responsive_control(
				'icon_margin',
				[
					'label' 		=> esc_html__( 'Margin', 'yachbat' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', 'em', '%' ],
					'selectors' 	=> [
						'{{WRAPPER}} .ova-contact-info .info .item i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Style tab Icon

		/**
		 * Info Style Tab Title
		 */
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'yachbat' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);


			$this->add_control(
				'title_color',
				[
					'label' 	=> esc_html__( 'Color', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .contact .info .item p' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_color_hover',
				[
					'label' 	=> esc_html__( 'Color hover', 'yachbat' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ova-contact-info .contact .info .item p:hover' => 'color : {{VALUE}};',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'info_typography',
					'selector' 	=> '{{WRAPPER}} .ova-contact-info .contact .info .item p',
				]
			);

			$this->add_responsive_control(
				'info_margin',
				[
					'label' 	 => esc_html__( 'Margin', 'yachbat' ),
					'type' 		 => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', 'em', '%' ],
					'selectors'  => [
						'{{WRAPPER}} .ova-contact-info .contact .info .item p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

		$this->end_controls_section(); 
		// End Label Style Tab Title	
	}

	// Render Template Here
	protected function render() {

		$settings = $this->get_settings();

		$icon 	= isset( $settings['icon']['value'] ) ? $settings['icon']['value'] : '';
		$label 	= $settings['label'] ? $settings['label'] : '';
		
		$items_info = $settings['items_info'];
		
		?>
			<div class="ova-contact-info ">
				<?php if ( $icon ): ?>

					<div class="icon">
						<i class="<?php echo esc_attr( $icon ); ?>"></i>
					</div>	

				<?php endif; ?>
				<div class="contact">

					<?php if ( $label ): ?>
						<div class="label">
							<?php echo esc_html( $label ); ?>
						</div>
					<?php endif; ?>

					<ul class="info">

						<?php foreach( $items_info as $item ):
							$type 	= $item['type'];
						?>
							<li class="item">

								<?php switch ( $type ) {

									case 'email':

										$email_title 	= $item['email_title'];
										$email_label 	= $item['email_label'];
										$email_icon 	= $item['icon_email']['value'];
										$email_link 	= $item['email_link'];
										?>
											<div class="ova-email">
												<?php
												if($email_icon){ ?>
														<i class="<?php echo esc_attr( $email_icon ); ?>"></i>
													<?php
												}
												if($email_title){ ?>
													<p><?php echo esc_html( $email_title ); ?></p>
													<?php
												}
												if($email_link){ ?>
													<a href="mailto:<?php echo esc_url( $email_link ); ?> ">
														<?php echo esc_html( $email_label ); ?>
													</a>
												<?php
												} else{
													echo esc_html( $email_label );
												}
												?>
											</div>
											<?php
										break;

									case 'phone':

										$phone_title 	= $item['phone_title'];
										$phone_label 	= $item['phone_label'];
										$phone_icon 	= $item['icon_phone']['value'];
										$phone_link	 	= $item['phone_link'];
										?> 
										<div class="ova-phone">
										<?php
											if($phone_icon){ ?>
											
													<i class="<?php echo esc_attr( $phone_icon ); ?>"></i>		
												<?php
											}
											if( $phone_title ) { ?>
												<p><?php echo esc_html( $phone_title ); ?></p>
											<?php }
											if($phone_link){ ?>
												<a href="tel:<?php echo esc_attr( $phone_link ); ?> ">
													<?php echo esc_html( $phone_label ); ?>
												</a>
											<?php
											} else{
												echo esc_html( $phone_label );
											}
										?>
										</div>
										<?php
										break;

									case 'link':

										$this->add_render_attribute( 'title' );
										$link_icon 		= $item['icon_link']['value'];
										$link_title 	= $item['link_title'];
										$link_label 	= $item['link_label'];
										$link_link 		= $item['link_address']['url'];
										$target_link 	= $item['link_address']['is_external'] ? ' target="_blank"' : '';
										?>
										<div class="ova-link">
										<?php
											if($link_icon){ ?>	
													<i class="<?php echo esc_attr( $link_icon ); ?>"></i>
												<?php
											}
											if($link_title){
												?>
												<p><?php echo esc_html( $link_title ); ?></p>
												<?php
											}
											if($link_label){ ?>
												<a href="<?php echo esc_url( $link_link ); ?> " <?php printf( $target_link ); ?>>
													<?php echo esc_html( $link_label ); ?>
												</a>
											<?php
											} else{
												echo esc_html( $link_label );
											} ?>
										</div>
										<?php
										break;
									case 'text':

										$text_icon = $item['icon_text']['value'];
										$text      = $item['text'];

										?>
										<div class="ova-text">
											<?php
												if($text_icon){ ?>	
													<i class="<?php echo esc_attr( $text_icon ); ?>"></i>
												<?php
												}
												if($text){
													echo esc_html( $text );
												}
											?>
										</div>
										<?php
										break;
										
									default:
										break;
								} ?>
							</li>
						<?php endforeach; ?>
					</ul>
				</div>
			</div>
		<?php
	}
	
}
$widgets_manager->register( new Yachbat_Elementor_Contact_Info() );