<?php
namespace ovabrw_product_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ovabrw_product_star_level extends Widget_Base {
	public function get_name() {		
		return 'ovabrw_product_star_level';
	}

	public function get_title() {
		return __( 'Product Star Level', 'ova-brw' );
	}

	public function get_icon() {
		return 'eicon-star';
	}

	public function get_categories() {
		return [ 'ovatheme' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_product_id_options',
			[
				'label' => esc_html__( 'Product Option', 'ova-brw' ),
				'tab' 	=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		    $this->add_control(
				'wc_content_warning',
				[
					'type' 	=> Controls_Manager::RAW_HTML,
					'raw' 	=> esc_html__( 'Don\'t Choose Product if you use this element in templates for product detail page.In Elementor Preview ( When empty Product ), this element display an example product tabs of the latest product', 'ova-brw' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);

			$arr_product 	= array( '0' => esc_html__( 'Choose Product', 'ova-brw' ) );
			$products 		= ovabrw_get_products_rental();

			if ( ! empty( $products ) && is_array( $products ) ) {
				foreach( $products as $product_id ) {
					$arr_product[$product_id] = get_the_title( $product_id );
				}
			} else {
				$arr_product[''] = esc_html__( 'There are no rental products', 'ova-brw' );
			}

			$this->add_control(
				'product_id',
				[
					'label' 	=> esc_html__( 'Choose Product', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> '0',
					'options' 	=> $arr_product,
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_product_star_level',
			[
				'label' => __( 'Content', 'ova-brw' ),
			]
		);

		    $this->add_control(
				'image',
				[
					'label' => esc_html__( 'Choose Image', 'ova-brw' ),
					'type' => \Elementor\Controls_Manager::MEDIA,
				]
			);

		    $this->add_control(
				'icon',
				[
					'label' 	=> esc_html__( 'Choose Icon', 'ova-brw' ),
					'type'  	=> Controls_Manager::ICONS,
					'default' 	=> [
						'value' 	=> 'icomoon icomoon-badge',
						'library' 	=> 'icomoon',
					],
				]
			);

		$this->end_controls_section();

	}

	protected function render() {
		$settings 	= $this->get_settings();
		$product_id = $settings['product_id'];

		global $product;

		if ( ! $product ) {
			$product = wc_get_product( $product_id );
		}

		if ( ! $product || ! $product->is_type('ovabrw_car_rental') ) { ?>
			<div class="ovabrw_elementor_no_product">
				<span><?php echo $this->get_title(); ?></span>
			</div>
		<?php return;
		}

		$img_url  	= $settings['image']['url'];
		$icon     	= $settings['icon']['value'];
		$product_id = $product->get_id();
		$star_level = get_post_meta( $product_id, 'ovabrw_star_level', true );

		?>
		<div class="elementor-product-star-level" style="background-image: url(<?php echo esc_attr( $img_url ) ;?>);">
			<div class="star-level-wrapper">
				<i class="<?php echo esc_attr( $icon ); ?>"></i>
				<span class="star-level">
					<?php echo esc_html($star_level).' '.esc_html__('Star','ova-brw'); ?>
				</span>
			</div>
		</div>
		<?php
	}
}