<?php
namespace ovabrw_product_elementor\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class ovabrw_product_info extends Widget_Base {

	public function get_name() {		
		return 'ovabrw_product_info';
	}

	public function get_title() {
		return __( 'Product Information', 'ova-brw' );
	}

	public function get_icon() {
		return 'eicon-product-info';
	}

	public function get_categories() {
		return [ 'ovatheme' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_product_id_options',
			[
				'label' => esc_html__( 'Product Option', 'ova-brw' ),
				'tab' 	=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		    $this->add_control(
				'wc_content_warning',
				[
					'type' 	=> Controls_Manager::RAW_HTML,
					'raw' 	=> esc_html__( 'Don\'t Choose Product if you use this element in templates for product detail page.In Elementor Preview ( When empty Product ), this element display an example product tabs of the latest product', 'ova-brw' ),
					'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
				]
			);

			$arr_product 	= array( '0' => esc_html__( 'Choose Product', 'ova-brw' ) );
			$products 		= ovabrw_get_products_rental();

			if ( ! empty( $products ) && is_array( $products ) ) {
				foreach( $products as $product_id ) {
					$arr_product[$product_id] = get_the_title( $product_id );
				}
			} else {
				$arr_product[''] = esc_html__( 'There are no rental products', 'ova-brw' );
			}

			$this->add_control(
				'product_id',
				[
					'label' 	=> esc_html__( 'Choose Product', 'ova-brw' ),
					'type' 		=> \Elementor\Controls_Manager::SELECT,
					'default' 	=> '0',
					'options' 	=> $arr_product,
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_item_info',
			[
				'label' => __( 'List Item', 'ova-brw' ),
			]
		);

			$this->add_responsive_control(
		        'item_border_radius',
	            [
	                'label' 		=> esc_html__( 'Border Radius', 'ova-brw' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ovabrw_product_info .yacht-info li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
		    );

		    $this->add_responsive_control(
	            'item_info_padding',
	            [
	                'label' 		=> esc_html__( 'Padding', 'ova-brw' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ovabrw_product_info .yacht-info li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

			$this->start_controls_tabs(
				'style_tabs'
			);

				$this->start_controls_tab(
					'style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'ova-brw' ),
					]
				);

					$this->add_group_control(
						\Elementor\Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'box_shadow',
							'label' => esc_html__( 'Box Shadow', 'ova-brw' ),
							'selector' => '{{WRAPPER}} .ovabrw_product_info .yacht-info li',
						]
					);

					$this->add_control(
						'item_bgcolor',
						[
							'label' 	=> esc_html__( 'Background Color', 'ova-brw' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ovabrw_product_info .yacht-info li' => 'background-color: {{VALUE}};',
							],
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'ova-brw' ),
					]
				);

					$this->add_group_control(
						\Elementor\Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'box_shadow_hover',
							'label' => esc_html__( 'Box Shadow', 'ova-brw' ),
							'selector' => '{{WRAPPER}} .ovabrw_product_info .yacht-info li:hover',
						]
					);

					$this->add_control(
						'item_bgcolor_hover',
						[
							'label' 	=> esc_html__( 'Background Color', 'ova-brw' ),
							'type' 		=> Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .ovabrw_product_info .yacht-info li:hover' => 'background-color: {{VALUE}};',
							],
						]
					);

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();

		/* Begin title Style */
		$this->start_controls_section(
            'title_style',
            [
                'label' => esc_html__( 'Title', 'ova-brw' ),
            ]
        );

            $this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' 		=> 'title_typography',
					'selector' 	=> '{{WRAPPER}} .ovabrw_product_info .yacht-info li span',
				]
			);

			$this->add_control(
				'title_color',
				[
					'label' 	=> esc_html__( 'Color', 'ova-brw' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ovabrw_product_info .yacht-info li span' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'title_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'ova-brw' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ovabrw_product_info .yacht-info li:hover span' => 'color: {{VALUE}};',
					],
				]
			);

        $this->end_controls_section();
		/* End title style */

		/* Begin icon Style */
		$this->start_controls_section(
            'icon_style',
            [
                'label' => esc_html__( 'Icon', 'ova-brw' ),
            ]
        );
            
			$this->add_responsive_control(
				'size_icon',
				[
					'label' 		=> esc_html__( 'Size', 'ova-brw' ),
					'type' 			=> Controls_Manager::SLIDER,
					'size_units' 	=> [ 'px'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 70,
							'step' => 1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .ovabrw_product_info .yacht-info li i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'icon_color',
				[
					'label' 	=> esc_html__( 'Color', 'ova-brw' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ovabrw_product_info .yacht-info li i' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_control(
				'icon_color_hover',
				[
					'label' 	=> esc_html__( 'Color Hover', 'ova-brw' ),
					'type' 		=> Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .ovabrw_product_info .yacht-info li:hover i' => 'color: {{VALUE}};',
					],
				]
			);

			$this->add_responsive_control(
	            'icon_margin',
	            [
	                'label' 		=> esc_html__( 'Margin', 'ova-brw' ),
	                'type' 			=> Controls_Manager::DIMENSIONS,
	                'size_units' 	=> [ 'px', '%', 'em' ],
	                'selectors' 	=> [
	                    '{{WRAPPER}} .ovabrw_product_info .yacht-info li i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
	            ]
	        );

        $this->end_controls_section();
		/* End icon style */
		
	}

	protected function render() {
		$settings 	= $this->get_settings();
		$product_id = $settings['product_id'];

		global $product;

		if ( ! $product ) {
			$product = wc_get_product( $product_id );
		}

		if ( ! $product || ! $product->is_type('ovabrw_car_rental') ) { ?>
			<div class="ovabrw_elementor_no_product">
				<span><?php echo $this->get_title(); ?></span>
			</div>
		<?php return;
		}

		$id = $product->get_id();

		// Get information
		$year           = get_post_meta( $id, 'ovabrw_year', true );
		$feet           = get_post_meta( $id, 'ovabrw_feet', true );
		$cabins         = get_post_meta( $id, 'ovabrw_cabins', true );
		$berths         = get_post_meta( $id, 'ovabrw_berths', true );

		// Get number people
		$max_adults     = get_post_meta( $id, 'ovabrw_adult_number', true );
		$max_childrens  = get_post_meta( $id, 'ovabrw_children_number', true );
		$people         = $max_adults + $max_childrens;

		?>

		<div class="ovabrw_product_info">
            <ul class="yacht-info">

                <?php if( !empty($people) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-users"></i>
						<span> 
							<?php echo esc_html( $people ) . ' ' . esc_html__('People', 'ova-brw') ; ?>	
						</span>
					</li>
				<?php endif; ?>
				<?php if( !empty($feet) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-ruler-combined"></i>
						<span> 
							<?php echo esc_html( $feet ); ?>	
						</span>
					</li>
				<?php endif; ?>
				<?php if( !empty($year) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-tools"></i>
						<span>
						    <?php echo esc_html( $year ); ?>	
						</span>
					</li>
				<?php endif; ?>
				<?php if( !empty($cabins) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-boat"></i>
						<span>
						    <?php echo esc_html( $cabins ) . ' ' . esc_html__('Cabins', 'ova-brw') ; ?>	
						</span>
					</li>
				<?php endif; ?>
				<?php if( !empty($berths) ) : ?>
					<li>
						<i aria-hidden="true" class="icomoon icomoon-user-circle"></i>
						<span>
						    <?php echo esc_html( $berths ) . ' ' . esc_html__('Berths', 'ova-brw'); ?>	
						</span>
					</li>
				<?php endif; ?>

			</ul>
		</div>

		<?php
	}

	
}