// onload reCAPTCHA v2
var ovabrwRECAPTCHAv2 = function() {
    // Booking
    if ( document.getElementById('ovabrw-booking-recaptcha') ) {
        grecaptcha.render(document.getElementById('ovabrw-booking-recaptcha'), {
            'sitekey' : ovabrwRECAPTCHA.site_key,
            'callback': ovabrwBookingVerify,
            'expired-callback': ovabrwBookingExpired,
            'error-callback': ovabrwBookingError
        });
    }

    // Request
    if ( document.getElementById('ovabrw-request-recaptcha') ) {
        grecaptcha.render(document.getElementById('ovabrw-request-recaptcha'), {
            'sitekey' : ovabrwRECAPTCHA.site_key,
            'callback': ovabrwRequestVerify,
            'expired-callback': ovabrwRequestExpired,
            'error-callback': ovabrwRequestError
        });
    }
};
// End

// onload reCAPTCHA v3
var ovabrwRECAPTCHAv3 = function( $ = jQuery ) {
    // Booking
    var bookingTokenInput = $('input[name="ovabrw-booking-recaptcha-token"]');

    // Request
    var requestTokenInput = $('input[name="ovabrw-request-recaptcha-token"]');

    if ( bookingTokenInput.length > 0 || requestTokenInput.length > 0 ) {
        grecaptcha.ready(function() {
            try {
                grecaptcha.execute(ovabrwRECAPTCHA.site_key, {action: 'ovabrwVerifyForm'}).then(function(token) {
                    if ( token ) {
                        if ( bookingTokenInput.length > 0 ) {
                            bookingTokenInput.closest('form').find('.ajax_loading').css('opacity', '1');
                            bookingTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                            bookingTokenInput.closest('form').find('.booking-error').html('').hide();
                        }

                        if ( requestTokenInput.length > 0 ) {
                            requestTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                            requestTokenInput.closest('form').find('.request-error').html('').hide();
                        }

                        // Verify token
                        $.ajax({
                            url: ajax_object.ajax_url,
                            type: 'POST',
                            data: ({
                                action: 'ovabrw_verify_recaptcha',
                                token: token
                            }),
                            success: function(response) {
                                // Booking
                                if ( bookingTokenInput.length > 0 ) {
                                    if ( response ) {
                                        bookingTokenInput.val('');
                                        bookingTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                                        bookingTokenInput.closest('form').find('.booking-error').html('').append(response).show();
                                    } else {
                                        bookingTokenInput.val(token);
                                        bookingTokenInput.closest('form').find('button[type="submit"]').prop('disabled', false);
                                        bookingTokenInput.closest('form').find('.booking-error').html('').hide();
                                    }

                                    bookingTokenInput.closest('form').find('.ajax_loading').css('opacity', '0');
                                }

                                // Request
                                if ( requestTokenInput.length > 0 ) {
                                    if ( response ) {
                                        requestTokenInput.val('');
                                        requestTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                                        requestTokenInput.closest('form').find('.request-error').html('').append(response).show();
                                    } else {
                                        requestTokenInput.val(token);
                                        requestTokenInput.closest('form').find('button[type="submit"]').prop('disabled', false);
                                        requestTokenInput.closest('form').find('.request-error').html('').hide();
                                    }
                                }
                            }
                        });
                        // End
                    } else {
                        // Booking
                        if ( bookingTokenInput.length > 0 ) {
                            bookingTokenInput.val('');
                            bookingTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                            bookingTokenInput.closest('form').find('.booking-error').html('').append(ovabrwRECAPTCHA.error).show();
                        }

                        // Request
                        if ( requestTokenInput.length > 0 ) {
                            requestTokenInput.val('');
                            requestTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                            requestTokenInput.closest('form').find('.request-error').html('').append(ovabrwRECAPTCHA.error).show();
                        }
                    }
                }).catch( function(error) {
                    // Booking
                    if ( bookingTokenInput.length > 0 ) {
                        bookingTokenInput.val('');
                        bookingTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                        bookingTokenInput.closest('form').find('.booking-error').html('').append(ovabrwRECAPTCHA.error).show();
                    }

                    // Request
                    if ( requestTokenInput.length > 0 ) {
                        requestTokenInput.val('');
                        requestTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                        requestTokenInput.closest('form').find('.request-error').html('').append(ovabrwRECAPTCHA.error).show();
                    }

                    console.error('Unexpected error: ', error);
                });
            } catch (error) {
                // Booking
                if ( bookingTokenInput.length > 0 ) {
                    bookingTokenInput.val('');
                    bookingTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                    bookingTokenInput.closest('form').find('.booking-error').html('').append(ovabrwRECAPTCHA.error).show();
                }

                // Request
                if ( requestTokenInput.length > 0 ) {
                    requestTokenInput.val('');
                    requestTokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                    requestTokenInput.closest('form').find('.request-error').html('').append(ovabrwRECAPTCHA.error).show();
                }

                console.error('Unexpected error: ', error);
            }
        });
    }
};
// End

// Booking Verify
var ovabrwBookingVerify = function( token, $ = jQuery ) {
    var tokenInput = $('input[name="ovabrw-booking-recaptcha-token"]');

    if ( tokenInput.length > 0 ) {
        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);

        if ( token ) {
            tokenInput.closest('form').find('.ajax_loading').css('opacity', '1');

            // Verify token
            $.ajax({
                url: ajax_object.ajax_url,
                type: 'POST',
                data: ({
                    action: 'ovabrw_verify_recaptcha',
                    token: token
                }),
                success: function(response) {
                    if ( response ) {
                        tokenInput.val('');
                        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                        tokenInput.closest('form').find('.booking-error').html('').append(response).show();
                    } else {
                        tokenInput.val(token);
                        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', false);
                        tokenInput.closest('form').find('.booking-error').html('').hide();
                    }

                    tokenInput.closest('form').find('.ajax_loading').css('opacity', '0');
                }
            });
        } else {
            tokenInput.val('');
            tokenInput.closest('form').find('.booking-error').html('').append(ovabrwRECAPTCHA.error).show();
        }
    }
}

// Booking Expired
var ovabrwBookingExpired = function( $ = jQuery ) {
    var tokenInput = $('input[name="ovabrw-booking-recaptcha-token"]');

    if ( tokenInput.length > 0 ) {
        tokenInput.val('');
        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
        tokenInput.closest('form').find('.booking-error').html('').append(ovabrwRECAPTCHA.expired).show();
    }
}

// Booking Error
var ovabrwBookingError = function( $ = jQuery ) {
    var tokenInput = $('input[name="ovabrw-booking-recaptcha-token"]');

    if ( tokenInput.length > 0 ) {
        tokenInput.val('');
        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
        tokenInput.closest('form').find('.booking-error').html('').append(ovabrwRECAPTCHA.error).show();
    }
}

// Request Verify
var ovabrwRequestVerify = function( token, $ = jQuery ) {
    var tokenInput = $('input[name="ovabrw-request-recaptcha-token"]');

    if ( tokenInput.length > 0 ) {
        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);

        if ( token ) {
            tokenInput.closest('form').find('.request-error').html('').hide();

            // Verify token
            $.ajax({
                url: ajax_object.ajax_url,
                type: 'POST',
                data: ({
                    action: 'ovabrw_verify_recaptcha',
                    token: token
                }),
                success: function(response) {
                    if ( response ) {
                        tokenInput.val('');
                        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
                        tokenInput.closest('form').find('.request-error').html('').append(response).show();
                    } else {
                        tokenInput.val(token);
                        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', false);
                        tokenInput.closest('form').find('.request-error').html('').hide();
                    }
                }
            });
        } else {
            tokenInput.val('');
            tokenInput.closest('form').find('.request-error').html('').append(ovabrwRECAPTCHA.error).show();
        }
    }
}

// Request Expired
var ovabrwRequestExpired = function( $ = jQuery ) {
    var tokenInput = $('input[name="ovabrw-request-recaptcha-token"]');

    if ( tokenInput.length > 0 ) {
        tokenInput.val('');
        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
        tokenInput.closest('form').find('.request-error').html('').append(ovabrwRECAPTCHA.expired).show();
    }
}

// Request Error
var ovabrwRequestError = function( $ = jQuery ) {
    var tokenInput = $('input[name="ovabrw-request-recaptcha-token"]');

    if ( tokenInput.length > 0 ) {
        tokenInput.val('');
        tokenInput.closest('form').find('button[type="submit"]').prop('disabled', true);
        tokenInput.closest('form').find('.request-error').html('').append(ovabrwRECAPTCHA.error).show();
    }
}

// Loader
var ovabrwRECAPTCHAonload = function() {}